<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

    <xsl:template match="property[@file='../../../install/deployment.properties']" priority="3">
        <xsl:element name="property">
            <xsl:attribute name="file">../conf/quickstarts.properties</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">org.jboss.esb.server.home</xsl:attribute>
            <xsl:attribute name="value">../../..</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">org.jboss.esb.server.config</xsl:attribute>
            <xsl:attribute name="value">default</xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="import[@file='${org.jboss.esb.home}/samples/quickstarts/conf/base-build.xml']" priority="3">
        <xsl:element name="import">
            <xsl:attribute name="file">../conf/base-build.xml</xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*">
        <xsl:variable name="attributeValue">
            <xsl:call-template name="replace">
                <xsl:with-param name="output" select="."/>
                <xsl:with-param name="target" select="'${org.jboss.as.home}'"/>
                <xsl:with-param name="replacement" select="'${org.jboss.esb.server.home}'"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:attribute name="{name()}">
            <xsl:call-template name="replace">
                <xsl:with-param name="output" select="$attributeValue"/>
                <xsl:with-param name="target" select="'${org.jboss.as.config}'"/>
                <xsl:with-param name="replacement" select="'${org.jboss.esb.server.config}'"/>
            </xsl:call-template>
        </xsl:attribute>
    </xsl:template>

    <xsl:template name="replace">
        <xsl:param name="output"/>
        <xsl:param name="target"/>
        <xsl:param name="replacement"/>
        <xsl:choose>
            <xsl:when test="contains($output, $target)">
                <xsl:value-of select="concat(substring-before($output, $target), concat($replacement, substring-after($output, $target)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$output"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
