package org.jboss.soa.esb.samples.quickstart.securitysaml;

import java.util.HashSet;
import java.util.Set;

import org.jboss.soa.esb.listeners.gateway.http.HttpMessageComposer;
import org.jboss.soa.esb.listeners.gateway.http.HttpRequestWrapper;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.security.SecurityService;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.ExtractionException;
import org.jboss.soa.esb.services.security.auth.ExtractorUtil;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.SamlAssertionExtractor;


public class HttpGatewayMessageComposer<T extends HttpRequestWrapper> extends HttpMessageComposer<T>
{
	protected void populateMessage(Message message, T requestWrapper) throws org.jboss.soa.esb.listeners.message.MessageDeliverException
	{
		super.populateMessage(message, requestWrapper);
		if( message.getContext().getContext(SecurityService.AUTH_REQUEST) == null )
		{
			//No auth request, maybe it was a SAML v2 Assertion in the security header. Let's try to add it
			try
			{
				Set<SecurityInfoExtractor<String>> extractors = new HashSet<SecurityInfoExtractor<String>>();
				extractors.add( new SamlAssertionExtractor() );
				AuthenticationRequest authRequest = ExtractorUtil.extract(message.getBody().get().toString(), extractors);
				ExtractorUtil.addAuthRequestToMessage(authRequest, message);
			}
			catch( ExtractionException e )
			{
				throw new MessageDeliverException( e.getMessage(), e );
			}
			catch( SecurityServiceException e )
			{
				throw new MessageDeliverException( e.getMessage(), e );
			}
		}
	}
}
