/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.cache;

import javax.naming.Context;
import javax.naming.InitialContext;

import org.apache.ode.bpel.iapi.Cache;
import org.apache.ode.bpel.iapi.CacheProvider;
import org.apache.ode.utils.GUID;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.ha.cachemanager.CacheManager;

/**
 * 
 * 
 * @author jeffyu
 *
 */
public class JBossCacheProvider implements CacheProvider {

	public static final String RIFTSAW_NODE_PREFIX = "jboss/riftsaw/";
	
	private CacheManager cacheManager;
	
	private org.jboss.cache.Cache cache;
	
	public void start() throws Exception {
		Context ctx = new InitialContext();
		cacheManager = (CacheManager) ctx.lookup("java:CacheManager");
		cache = cacheManager.getCache("riftsaw-cache", true);
		cache.start();
	}
	
	public <K, V> Cache<K, V> createCache() {
		
		String fqnString = RIFTSAW_NODE_PREFIX + new GUID().toString();
		Fqn<String> theFqn = Fqn.fromString(fqnString);			
		Cache<K, V> result = new JBossCache<K, V>(cache, theFqn);
		return result;
	}
	
	public void stop() throws Exception {
		cacheManager.releaseCache("riftsaw-cache");
	}

}
