/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.server.http_proxy;

import java.io.InputStream;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

import junit.framework.Test;

import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.test.JBossTestCase;

/**
 * Test SOAPProxy via HttpGateway.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class HttpProxyUnitTest extends JBossTestCase
{
    /**
     * The name of the deployment archive.
     */
    private static final String ESB_ARCHIVE = "http_proxy.esb" ;
    /**
     * The name of the ws archive.
     */
    private static final String WS_ARCHIVE = "http_proxy_ws.war" ;
    /**
     * The WSDL location.
     */
    private static final String WSDL_URL = "http://127.0.0.1:8080/http_proxy/http/Test/SOAPProxyTest?wsdl" ;
    
    /**
     * Construct the test case with the specified name.
     * @param name The name of the test case.
     */
    public HttpProxyUnitTest(final String name)
    {
        super(name) ;
    }
    
    /**
     * Test WSDL generation.
     * @throws Exception For any failures.
     */
    public void testWSDLGeneration()
        throws Exception
    {
        final URL wsdlUrl = new URL(WSDL_URL) ;
        final InputStream is = wsdlUrl.openStream() ;
        try
        {
            final XMLStreamReader reader = XMLHelper.getXMLStreamReader(is) ;
            StreamHelper.skipToNextStartElement(reader) ;
            assertEquals("definitions local name", "definitions", reader.getLocalName()) ;
            // Should be an embedded element here
            StreamHelper.skipToNextStartElement(reader) ;
            assertEquals("types local name", "types", reader.getLocalName()) ;
        }
        finally
        {
            try
            {
                is.close() ;
            }
            catch (final Throwable th) {} // ignore
        }
    }
    
    /**
     * Create the test suite.
     * @return The suite representing this test case.
     */
    public static Test suite()
        throws Exception
    {
        return getDeploySetup(HttpProxyUnitTest.class, WS_ARCHIVE + ", " + ESB_ARCHIVE);
    }
}
