/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.server.epr;

import java.util.Iterator;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference.Extension;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;

/**
 * @author <a href="mailto:Kevin.Conner@jboss.com">Kevin Conner</a>
 */
public class Service4Action extends AbstractActionPipelineProcessor
{
    public static final String TEST_URI = "http://labs.jboss.org/jbossesb/testing/test-uri" ;
    
    public Service4Action(final ConfigTree config)
        throws MessageDeliverException
    {
    }

    public Message process(final Message message)
        throws ActionProcessingException
    {
        final Call call = message.getHeader().getCall() ;
        final EPR toEPR = call.getTo() ;
        final Iterator<Extension> extensions = toEPR.getAddr().getExtensions() ;
        if (extensions.hasNext())
        {
            final StringBuilder sb = new StringBuilder() ;
            do
            {
                final Extension extension = extensions.next() ;
                if (TEST_URI.equals(extension.getURI()))
                {
                    sb.append("Prefix " + extension.getPrefix()) ;
                    sb.append(" Tag " + extension.getTag()) ;
                    sb.append(" value " + extension.getValue()) ;
                }
            }
            while(extensions.hasNext()) ;
            message.getBody().add(sb.toString()) ;
        }

        return message;
    }
}
