/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.registry.systinet;

import com.systinet.wasp.webservice.CallContextImpl;
import com.systinet.wasp.webservice.CurrentImpl;
import org.idoox.transport.server.ServerConnection;
import org.idoox.wasp.Context;
import org.idoox.wasp.SecurityHelper;
import java.util.Map;
import java.util.HashMap;

/**
* Contains functions that must be used demarcate calls
* to internal Systinet registry APIs.
*/   
public class CallDemarcation {
   /**
    * Return the call context
    */       
   private static CallContextImpl getCallContext() {	   	
        CurrentImpl current = (CurrentImpl)Context.getInstance(org.systinet.wasp.webservice.ICurrent.class);
        // get SSJ's current contexts
        
        // get thread local state (InheritableThreadLocal) 
        CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
        // get or initialize call context
        CallContextImpl callCtx = (CallContextImpl)threadLocals.callContext;
        if (callCtx == null){
            callCtx = new CallContextImpl(new HashMap(5), new HashMap(5));
            threadLocals.callContext = callCtx;
        }
        return callCtx;
   }

   /**
	* Called before using registry's internal APIs, a threadlocal state 
	* is authenticated by a username/password.
	* @param userName userName to authenticate    
	* @param password password to authenticate with
	*/       
   public static void beginCall(String userName, String password) throws Exception {
	   boolean auth = SecurityHelper.authenticateClient(userName, password, SecurityHelper.HttpBasic);
	   if (!auth) {
		   throw new Exception("Could not authenticate Systinet transport client");
	   }
	   
	   CallContextImpl callCtx = getCallContext(); 
	   callCtx.beginCall();
   }
   
   /**
	* End the call.
	*/  
   public static void endCall(){
	   CallContextImpl callCtx = getCallContext(); 
	   callCtx.endCall();
   } 
}
