/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.services.soapui;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

import javax.xml.parsers.ParserConfigurationException;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.HttpClientFactory;
import org.xml.sax.SAXException;

/**
 *
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */
public class JBESB_3327_SoapUIClientServiceMBeanUnitTest extends TestCase {

    private static final String WSDL_LOCATAION = "src/test/java/org/jboss/soa/esb/services/soapui";
    private Properties properties;

    protected void setUp() throws Exception {
        properties = new Properties();
    }

    public void test_collection_in_response() throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        File wsdlFile = new File(WSDL_LOCATAION + "/collectionresponse.wsdl");
        SoapUIClientService mbean = new SoapUIClientService();
        String response = 
                        "<env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'>\n" +
                        "   <env:Header>\n" +
                        "   </env:Header>\n" +
                        "   <env:Body>\n" +
                        "      <ord:processOrderResponse xmlns:ord='http://webservice_consumer_list/orderProcessor'>\n" +
                        "         <OrderStatus>\n" +
                        "            <id>1</id>\n" +
                        "            <comment>order processed</comment>\n" +
                        "            <returnCode>1</returnCode>\n" +
                        "            <lineItems>\n" +
                        "               <id>1</id>\n" +
                        "               <name>Item1</name>\n" +
                        "               <price>10</price>\n" +
                        "               <comments>Item1 Comments1</comments>\n" +
                        "               <comments>Item1 Comments2</comments>\n" +
                        "            </lineItems>\n" +
                        "            <lineItems>\n" +
                        "               <id>2</id>\n" +
                        "               <name>Item2</name>\n" +
                        "               <price>15</price>\n" +
                        "               <comments>Item2 Comments1</comments>\n" +
                        "               <comments>Item2 Comments2</comments>\n" +
                        "               <comments>Item2 Comments3</comments>\n" +
                        "               <comments>Item2 Comments4</comments>\n" +
                        "            </lineItems>\n" +
                        "         </OrderStatus>\n" +
                        "      </ord:processOrderResponse>\n" +
                        "   </env:Body>\n" +
                        "</env:Envelope>\n";

        String expected = "expected_JBESB_3327_01.xml";

        properties.setProperty(HttpClientFactory.TARGET_HOST_URL, wsdlFile.toURI().toString());

        String message = mbean.mergeResponseTemplate(wsdlFile.toURI().toString(), "processOrder", null, response, properties, null, null);

        assertTrue("Generated SOAP message not as expected. See " + expected + ".  Generated message: \n" + 
                    message, XMLHelper.compareXMLContent(getClass().getResourceAsStream(expected), new ByteArrayInputStream(message.getBytes())));
    }
}