/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.services.soapui;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.xml.parsers.ParserConfigurationException;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.http.HttpClientFactory;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;

/**
 *
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */
public class AnyTypeSoapUIClientServiceMBeanUnitTest extends TestCase {

    private static final String WSDL_LOCATAION = "src/test/java/org/jboss/soa/esb/services/soapui";
    private Properties properties;

    protected void setUp() throws Exception {
        properties = new Properties();
    }

    public void test_anytype_in_request() throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        File wsdlFile = new File(WSDL_LOCATAION + "/anytypehelloworld.wsdl");
        SoapUIClientService mbean = new SoapUIClientService();
        String request = 
                        "<books>\n" +
                        "   <book>\n" +
                        "      <name>JBoss ESB Beginners Guide</name>\n" +
                        "   </book>\n" +
                        "</books>\n";

        Map map = new HashMap();
        map.put("sayHi", request);
        map.put("dumpSOAP", "true");
        String expected = "anytype_request.xml";

        properties.setProperty(HttpClientFactory.TARGET_HOST_URL, wsdlFile.toURI().toString());

        String message = mbean.buildRequest(wsdlFile.toURI().toString(), "HelloWorldPubServiceOp", "{http://soa.jboss.org/ESBServiceSample}HelloWorldPubServiceService", map, properties, null, null);

        assertTrue("Generated SOAP message not as expected. See " + expected + ".  Generated message: \n" + 
                    message, XMLHelper.compareXMLContent(getClass().getResourceAsStream(expected), new ByteArrayInputStream(message.getBytes())));
    }

    public void test_anytype_in_response() throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        File wsdlFile = new File(WSDL_LOCATAION + "/anytypehelloworld.wsdl");
        SoapUIClientService mbean = new SoapUIClientService();
        String response = 
                        "<books>\n" +
                        "   <book>\n" +
                        "      <name>JBoss ESB Beginners Guide</name>\n" +
                        "      <authors>\n" +
                        "         <author>Len DiMaggio</author>\n" +
                        "         <author>Kevin Conner</author>\n" +
                        "         <author>Tom Cunningham</author>\n" +
                        "         <author>Magesh Kumar B</author>\n" +
                        "      </authors>\n" +
                        "   </book>\n" +
                        "</books>\n";

        Map map = new HashMap();
        map.put("sayHiResponse", response);
        map.put("dumpSOAP", "true");
        String expected = "anytype_response.xml";
        String expectedMerged = "anytype_response_merged.xml";

        properties.setProperty(HttpClientFactory.TARGET_HOST_URL, wsdlFile.toURI().toString());

        String message = mbean.buildResponse(wsdlFile.toURI().toString(), "HelloWorldPubServiceOp", "{http://soa.jboss.org/ESBServiceSample}HelloWorldPubServiceService", map, properties, null, null);

        assertTrue("Generated SOAP message not as expected. See " + expected + ".  Generated message: \n" + 
                    message, XMLHelper.compareXMLContent(getClass().getResourceAsStream(expected), new ByteArrayInputStream(message.getBytes())));

        String mergedMessage = mbean.mergeResponseTemplate(wsdlFile.toURI().toString(), "HelloWorldPubServiceOp", "{http://soa.jboss.org/ESBServiceSample}HelloWorldPubServiceService", message, properties, null, null);

        // This comparison ignores comments
        assertTrue("Merged SOAP message not as expected. See " + expected + ".  Generated message: \n" + 
                    message, XMLHelper.compareXMLContent(getClass().getResourceAsStream(expectedMerged), new ByteArrayInputStream(mergedMessage.getBytes())));
        // Test if the comment was added
        assertTrue(mergedMessage.indexOf("<!--You may enter ANY elements at this point-->") > 0);
    }
}