/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.soap.wise;

import it.javalinux.wise.core.client.InvocationResult;
import it.javalinux.wise.core.client.WSEndpoint;
import it.javalinux.wise.core.client.WSMethod;
import it.javalinux.wise.core.mapper.WiseMapper;
import it.javalinux.wise.core.exceptions.WiseException;
import org.jboss.soa.esb.actions.soap.wise.ContinueOnFaultThreadLocal;

import java.util.Map;

import java.lang.reflect.InvocationTargetException;

import org.jboss.aop.joinpoint.MethodInvocation;


/**
 * WISE should process valid SOAPFaultExceptions - this aspect will rethrow a InvocationTargetException
 * as a WiseException with the InvocationTargetException as the cause.    This exception can then 
 * be processed as a valid response in SOAPClient.
 * 
 * @author tcunning 
 */
public class WSMethodInvokeAspect {    
    public InvocationResult invoke(final MethodInvocation invocation) throws WiseException
    {   
        final Object[] invocationArgs = invocation.getArguments() ;
        final Object args = invocationArgs[0];
        final WiseMapper mapper = (WiseMapper) invocationArgs[1];
        
        final WSMethod wsMethod = (WSMethod)invocation.getTargetObject();
        
        if (!ContinueOnFaultThreadLocal.get().booleanValue()) {
            try {
                return (InvocationResult) invocation.invokeNext();
            } catch (Throwable t) {
                throw new WiseException("Unknown Exception " + t);
            }            
        }
        
        if (mapper == null) {
            try {
                return (InvocationResult) invocation.invokeNext();
            } catch (WiseException we) {
                throw we;
            } catch (Throwable t) {
                throw new WiseException("Unknown Exception " + t);
            }   
        }       
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Map mappingResults;
            try { 
                WSEndpoint wsEndpoint = wsMethod.getEndpoint();
                Thread.currentThread().setContextClassLoader(wsEndpoint.getClassLoader());
                mappingResults = mapper.applyMapping(args);
            } finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }            
            // Set the arguments, with the mapper set to null, so that we call the no-mapper upon reinvocation
            Object tempArgs[] = new Object[2];
            tempArgs[0] = args;
            tempArgs[1] = null;
            invocation.setArguments(tempArgs);
            return (InvocationResult) invocation.invokeNext();
        } catch (InvocationTargetException ite) {
            WiseException.rethrow("Unknown exception received: " + ite.getMessage(), ite);
        } catch (WiseException e) {
            WiseException.rethrow("Unknown exception received: " + e.getCause().getMessage(), e.getCause());
        } catch (Throwable t) {
            WiseException.rethrow("Unknown exception received: " + t.toString(), t);
        }
    
        throw new WiseException("Transformation Failed");
    }
}
