/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.smooks;

import junit.framework.TestCase;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.testutils.ESBConfigUtil;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ProfilingUnitTest extends TestCase {

    private ESBConfigUtil esbConfig;
    private byte[] personXmlBytes = StreamUtils.readStream(SourceResultUnitTest.class.getResourceAsStream("message/person.xml"));

    protected void setUp() throws Exception {
        esbConfig = new ESBConfigUtil(getClass().getResourceAsStream("profiling-esb.xml"));
        esbConfig.setESBProperties(getClass().getResourceAsStream("jbossesb-properties.xml"));
        esbConfig.installRegistry();
        esbConfig.startController();
    }

    protected void tearDown() throws Exception {
        esbConfig.stopController();
        esbConfig.uninstallRegistry();
        esbConfig.resetESBProperties();
    }

    public void test() throws RegistryException, FaultMessageException, MessageDeliverException {
        test("profile1", "<someone called=\"Tom Fennelly\" is=\"21\">");
        test("profile2", "<person name=\"Tom Fennelly\" age=\"21\">");
    }

    private void test(String profile, String expected) throws MessageDeliverException, RegistryException, FaultMessageException {
        ServiceInvoker invoker = new ServiceInvoker("Transform", "String");
        Message message = MessageFactory.getInstance().getMessage();

        // Create the message and set the profile on it...
        message.getBody().add(new String(personXmlBytes));
        message.getProperties().setProperty(Properties.MESSAGE_PROFILE, profile);

        message = invoker.deliverSync(message, 30000);

        assertEquals(expected, message.getBody().get());
    }
}
