/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm5.model;

/**
 * Process type enum.
 *  
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.11
 */
public enum ProcessType {
	/** startProcess . */
    START_PROCESS(ProcessConstants.START_PROCESS_TYPE),
    /** signalEvent . */
    SIGNAL_EVENT(ProcessConstants.SIGNAL_EVENT_TYPE),
    /** abortProcessInstance . */
    ABORT_PROCESS_INSTANCE(ProcessConstants.ABORT_PROCESS_INSTANCE_TYPE);

    private final String _action;
        
    /**
     * Constructs a new ProcessActionType with the specified action.
     * @param action the action
     */
    ProcessType(String action) {
        _action = action;
    }

    /**
     * Gets the action.
     * @return the action
     */
    public String action() {
        return _action;
    }

    /**
     * Gets the ProcessActionType matching the specified action.
     * @param action the action
     * @return the matching ProcessActionType
     */
    public static ProcessType fromAction(String action) {
        for (ProcessType pat : values()) {
            if (pat.action().equals(action)) {
                return pat;
            }
        }
        return null;
    }

}
