/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.services.jbpm.cmd;

import java.util.List;
import java.util.Map;

import org.jboss.internal.soa.esb.addressing.helpers.EPRHelper;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.MarshalException;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.jbpm.Constants;
import org.jboss.soa.esb.services.jbpm.JBpmObjectMapper;
import org.jboss.soa.esb.services.jbpm.Mapping;
import org.jboss.soa.esb.services.jbpm.Constants.OpCode;

/**
 *
 * Implementation of a message preprocessor to obtain data from a process instance 
 * from the action configuration XML
 * 
 * @author <a href="mailto:schifest@heuristica.com.ar">schifest@heuristica.com.ar</a> 
 */
public class NewProcessInstanceFacade extends MessageFacade
{
	public OpCode getOpCode() 
	{ 
		return (_start) 
				?Constants.OpCode.StartProcessInstanceCommand
				:Constants.OpCode.NewProcessInstanceCommand; 
	}

	public NewProcessInstanceFacade(ConfigTree config, boolean start) throws ConfigurationException
	{
		_start		= start;
		_actor		= config.getAttribute(Constants.ONE_ACTOR_TAG);
		_processName= config.getAttribute(Constants.PROCESS_DEFINITION_NAME_TAG);
        _keyPath    = config.getAttribute(Constants.KEY_TAG);
		String pId	= config.getAttribute(Constants.PROCESS_DEFINITION_ID_TAG);
		if (null!=pId) {
			try {
                _processId = Long.parseLong(pId); 
            } catch(NumberFormatException e) {
				throw new ConfigurationException("Invalid value for '"+Constants.PROCESS_DEFINITION_ID_TAG+"'");
			}
        }
        _esbToBpm	= ConfigUtil.getMappingConfig(config);
		if (_start) {
			_transitionName	= config.getAttribute(Constants.TRANSITION_NAME_TAG);
        }
		_replyToOriginator = config.getBooleanAttribute(Constants.REPLY_TO_ORIGINATOR_TAG, false) ;
	}
	
	public void setJBPMContextParameters(Message message) 
	{
		Body body = message.getBody();

        if (null!=_keyPath)
            body.add(Constants.KEYPATH, _keyPath);

        if (null!=_actor)
			body.add(Constants.ACTOR_ID	,_actor);

        if (null!=_processName)
			body.add(Constants.PROCESS_DEFINITION_NAME	,_processName);

        if (null!=_processId)
			body.add(Constants.PROCESS_DEFINITION_ID	,_processId);

        if (null!=_transitionName)
			body.add(Constants.TRANSITION_NAME, _transitionName);

        Map<String,Object> variableMap = _mapper.mapFromEsbMessageToJBpmMap(message,_esbToBpm);

        if (null!=variableMap)
            body.add(Constants.VARIABLE_VALUES, variableMap);

        if (_replyToOriginator) {
            final Call call = message.getHeader().getCall() ;
            setEPR(body, Constants.REPLY_TO, getEPR(call.getReplyTo())) ;
            setEPR(body, Constants.FAULT_TO, getEPR(call.getFaultTo())) ;
        }
	}
	
    private void setEPR(final Body body, final String name, final String value)
    {
        if (value == null)
        {
            body.remove(name) ;
        }
        else
        {
            body.add(name, value) ;
        }
    }
    
	private String getEPR(final EPR epr)
	{
		if (epr == null) {
			return null ;
		}
		
		try {
			return EPRHelper.toXMLString(epr) ;
		} catch (final MarshalException me) {
			throw new IllegalArgumentException("Failed to marshall epr", me) ;
		}
	}

	boolean			_start;
    String          _keyPath;
	String			_actor;
	String			_processName;
	String			_transitionName;
	Long			_processId;
	List<Mapping>   _esbToBpm;
    JBpmObjectMapper _mapper = new JBpmObjectMapper();
    private boolean _replyToOriginator ;
}
