/**
 * 
 */
package org.jboss.soa.esb.services.jbpm.cmd;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.jbpm.Constants;

/**
 * @author kstam
 *
 */
public abstract class MessageFacade
{
    /**
     * Obtain the operation code that this preprocessor will force into the command message
     * @return Constants.OpCode
     */
    public abstract Constants.OpCode getOpCode();
    /**
     * Some message values are fixed at action configuration time (from the jboss-esb.xml).
     * <br/>This method is responsible of stuffing these static values into every Message
     * before passing it to the generic CommandInterpreter process(Message) method
     * <br/>Some of the Message content will thus come from configuration XML, and some will
     * be the users' responsibility (e.g. processId, tokenId, etc)
     * <br/>Variable name mapping between esb and jBPM is also handled by this interface
     * @param request Message - Into which the static values will be added
     */
    public abstract void setJBPMContextParameters(Message request);
    
    
    public static MessageFacade getFacade(ConfigTree config) 
    throws ConfigurationException, UnsupportedOperationException
    {
        Constants.OpCode opCode = null;
        String sAux = config.getRequiredAttribute(Constants.COMMAND_CODE_TAG);
        try { 
            opCode = Constants.OpCode.valueOf(sAux);
        } catch (IllegalArgumentException e) {
            throw new ConfigurationException("Attribute '"+Constants.COMMAND_CODE_TAG+"' has an invalid value"
                        +"- see Constants.OpCode enum for possible values");
        }
        
        if (Constants.OpCode.CancelProcessInstanceCommand.equals(opCode))
            return new CancelProcessInstanceFacade(config);
        if (Constants.OpCode.NewProcessInstanceCommand.equals(opCode))
            return new NewProcessInstanceFacade(config, false);
        if (Constants.OpCode.StartProcessInstanceCommand.equals(opCode))
            return new NewProcessInstanceFacade(config, true);
        if (Constants.OpCode.GetProcessInstanceVariablesCommand.equals(opCode))
            return new GetProcessVariablesFacade(config);

        throw new UnsupportedOperationException(opCode.toString()+" not implemented");
    }
}
