/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.services.jbpm.cmd;

import org.jboss.soa.esb.services.jbpm.Constants;
import org.jboss.soa.esb.services.jbpm.Mapping;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.ConfigurationException;

import java.util.List;

/**
 * Get process variable facade.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class GetProcessVariablesFacade  extends MessageFacade {

    private List<Mapping> mappings;

    public GetProcessVariablesFacade(ConfigTree configTree) throws ConfigurationException {
        mappings = ConfigUtil.getMappingConfig(configTree);
    }

    public Constants.OpCode getOpCode() {
        return Constants.OpCode.GetProcessInstanceVariablesCommand;
    }

    public void setJBPMContextParameters(Message message) {
        message.getBody().add(Constants.BPM_TO_ESB_VARS_TAG, mappings);
    }

    public static List<Mapping> getMappings(Message message) {
        return (List<Mapping>) message.getBody().get(Constants.BPM_TO_ESB_VARS_TAG);
    }
}
