/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.services.jbpm.actions;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycle;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.jbpm.Constants;
import org.jboss.soa.esb.services.jbpm.cmd.Command;
import org.jboss.soa.esb.services.jbpm.cmd.CommandExecutor;

/**
* @author <a href="mailto:kurt.stam@jboss.com">Kurt Stam</a>
*/
public class JBpmCallback implements ActionLifecycle
{
    public static final String JBPM_CALL_BACK_SERVICE_NAME = "JBpmCallbackService";
    protected ConfigTree  configTree;
    private static Logger logger = Logger.getLogger(JBpmCallback.class);

    public void destroy() throws ActionLifecycleException {
        logger.info("destroy() invoked");
    }
    public void initialise() throws ActionLifecycleException {
        logger.info("initialise() invoked - config="+configTree);
    }
    
	public JBpmCallback(ConfigTree configTree) throws ConfigurationException
	{ 
        this.configTree = configTree;
	}
	/**
     * 
     * @param message
     * @return
     * @throws ActionProcessingException
	 */
	public Message process(Message message) throws ConfigurationException
	{     
        //Send a callback signal to jBPM
        CommandExecutor commandExecutor = CommandExecutor.getInstance();
        String commandString  = Constants.OpCode.CallbackCommand.toString();
        Command command = commandExecutor.getCommand(commandString);
        command.execute(message);
        return message;
	}
    
}
