/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth;

import static org.junit.Assert.*;

import java.security.Principal;

import org.jboss.soa.esb.services.security.TestPrincipal;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;

/**
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class AuthenticationRequestUnitTest
{
	@Test
	public void contruct()
	{
		final Principal principal = new TestPrincipal("testUser");
		AuthenticationRequest request = new AuthenticationRequestImpl.Builder(principal, null ).build();
		assertEquals( principal, request.getPrincipal());
	}
	
	@Test
	public void build()
	{
		final String username = "Donald";
		final String password = "Duck123";
		AuthenticationRequest request = new AuthenticationRequestImpl.Builder().username(username).password(password.toCharArray()).build();
		assertEquals( username, request.getPrincipal().getName() );
		assertTrue( request.getCredentials().size() == 1 );
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(AuthenticationRequestUnitTest.class);
	}

}
