/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.config.mappers130;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import junit.framework.JUnit4TestAdapter;

import org.apache.xmlbeans.XmlException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.config.xbeanmodel130.JbossesbDocument.Factory;
import org.jboss.soa.esb.listeners.config.xbeanmodel130.ServiceDocument.Service;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Unit test for {@link SecurityMapper}
 * <p/>
 * 
 * @author Daniel Bevenius
 *
 */
public class SecurityMapperUnitTest
{
	private static final String ESB_CONFIG = "jbossesb_config_security.xml";
	
	private Element root;
	private XMLBeansModel model;

	private Service service;

	private Node securityNode;
	
	@Test
	public void mapRunAs() throws ConfigurationException
	{
		Node runAsNode = securityNode.getAttributes().getNamedItem( ListenerTagNames.RUN_AS_TAG );
		assertNotNull( runAsNode.getNodeName() );
		assertEquals( "MrPoon", runAsNode.getNodeValue() );
	}
	
	@Test
	public void mapModuleName() throws ConfigurationException
	{
		Node moduleNameNode = securityNode.getAttributes().getNamedItem( ListenerTagNames.MODULE_NAME_TAG );
		assertNotNull( moduleNameNode.getNodeName() );
		assertEquals( "mod1", moduleNameNode.getNodeValue());
	}
	
	@Test
	public void mapUseCallersIdentity() throws ConfigurationException
	{
		Node userIdentityNode = securityNode.getAttributes().getNamedItem( ListenerTagNames.USE_CALLERS_IDENTIDY_TAG );
		assertNotNull( userIdentityNode.getNodeName() );
		assertEquals( "user1", userIdentityNode.getNodeValue());
	}
	
	//	setup methods
	
	@Before
	public void setup() throws ConfigurationException, IOException, XmlException
	{
		root = createRootElement();
		model = getXmlBeanModel( ESB_CONFIG );
		service = model.getServices().get( 0 );
		
		SecurityMapper.map( root, service );
		securityNode = root.getFirstChild();
	}
	
	private XMLBeansModel getXmlBeanModel( String fileName ) throws ConfigurationException, IOException, XmlException
	{
		InputStream inputStream = getClass().getResourceAsStream( ESB_CONFIG );
		final Reader reader = new InputStreamReader(inputStream);
		XMLBeansModel model = new XMLBeansModel(Factory.parse(reader).getJbossesb());
		return model;
	}
	
	private Element createRootElement() throws ConfigurationException
	{
		Document doc = YADOMUtil.createDocument();
		Element root = YADOMUtil.addElement(doc, "jbossesb-gateways");
		root.setAttribute("parameterReloadSecs", "1000" );
		return root;
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( SecurityMapperUnitTest.class );
	}
}
