/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.EPR;

import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

import java.util.List;

public class RegistryUtilUnitTest extends ListenerManagerBaseTest
{
	@SuppressWarnings("unused")
	private Logger log = Logger.getLogger( RegistryUtilUnitTest.class );
	
	public void setUp() throws Exception {
		runBeforeAllTests();
	}
	
	public void tearDown() throws Exception
	{
		runAfterAllTests();
	}
	
	public void testJBESB3747() throws Exception
	{
		RegistryUtil.getEprManager();
		HTTPEpr epr = new HTTPEpr("http://foo.bar");
		ConfigTree tree = new ConfigTree("test");
		
		tree.setAttribute(ListenerTagNames.SERVICE_CATEGORY_NAME_TAG, "eprmanager");
		tree.setAttribute(ListenerTagNames.SERVICE_NAME_TAG, "test");
		tree.setAttribute(ListenerTagNames.REMOVE_OLD_SERVICE, "true");

		RegistryUtil.register(tree, epr);

		boolean exception = false;
		try
		{
			RegistryUtil.getEprs("eprmanager", "test");
		}
        catch (ServiceNotFoundException ex)
        {
            exception = true;
            ex.printStackTrace();
        }
		catch (RegistryException ex)
		{
			exception = true;
			ex.printStackTrace();
		}
		
		if (exception)
			fail("Received exception when querying for foobar:test");		

		RegistryUtil.unregister("eprmanager", "test", epr);

	}
	
	public void testRegistryUtil () throws Exception
	{
		RegistryUtil.getEprManager();
		HTTPEpr epr = new HTTPEpr("http://foo.bar");
		ConfigTree tree = new ConfigTree("test");
		
		tree.setAttribute(ListenerTagNames.SERVICE_CATEGORY_NAME_TAG, "eprmanager");
		tree.setAttribute(ListenerTagNames.SERVICE_NAME_TAG, "test");
		
		RegistryUtil.register(tree, epr);
		RegistryUtil.unregister("eprmanager", "test", epr);
		
		boolean exception = false;
		
		try
		{
			// case difference is deliberate!
			
			RegistryUtil.getEprs("eprmanager", "test");
            fail("Expected RegistryException");
        }
		catch (RegistryException ex)
		{
		}
		
		RegistryUtil.register(tree, epr);
		
		List<EPR> eprList = null;
		try
		{
			eprList = RegistryUtil.getEprs("eprmanager", "test");
			assertEquals(1, eprList.size());
		}
		catch (RegistryException ex)
		{
			fail();
		}
		
		RegistryUtil.unregister("eprmanager", "test", epr);
		
		exception = false;
		
		try
		{
			RegistryUtil.getEprs("foobar", "test");
		}
        catch (ServiceNotFoundException ex)
        {
            exception = true;
        }
		catch (RegistryException ex)
		{
			exception = true;
		}
		
		if (!exception)
			fail();
		
		tree.setAttribute(ListenerTagNames.SERVICE_NAME_TAG, "");
		
		try
		{
			RegistryUtil.register(tree, epr);
			
			fail();
		}
		catch (RegistryException ex)
		{
		}
		
		@SuppressWarnings("unused")
        ListenerInitializationException exp = new ListenerInitializationException();
		
		exp = new ListenerInitializationException("bad things");
		exp = new ListenerInitializationException("more bad things", new RuntimeException());
		exp = new ListenerInitializationException(new RuntimeException());
		
		try
		{
			RegistryUtil.unregister("eprmanager", "", epr);
		}
		catch (Exception ex)
		{
			fail();
		}
		
		try
		{
			RegistryUtil.getEprs("", "test");
			
			fail();
		}
        catch (ServiceNotFoundException ex)
        {
        }
		catch (RegistryException ex)
		{
		}
	}
	
}
