/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.transformation.xslt;

import static org.junit.Assert.*;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

import junit.framework.JUnit4TestAdapter;

import org.junit.Test;

/**
 * Unit test for {@link SourceFactory}.
 * <p/>
 * 
 * Code contributed from the Smooks project.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class SourceFactoryUnitTest
{
    private SourceFactory factory = SourceFactory.getInstance();
    
    @Test
    public void createStreamSourceStreamFromString()
    {
        final Source source = factory.createSource( "testing" );
        assertNotNull( source );
        assertTrue( source instanceof StreamSource );
    }
    
    @Test
    public void getSourceByteArray()
    {
        final Source source = factory.createSource( "test".getBytes() );
        assertNotNull( source );
        assertTrue( source instanceof StreamSource );
    }
    
    @Test
    public void getSourceReader()
    {
        final Source source = factory.createSource( new StringReader( "testing" ));
        assertNotNull( source );
        assertTrue( source instanceof StreamSource );
    }
    
    @Test
    public void getSourceInputStream()
    {
        final Source source = factory.createSource( new ByteArrayInputStream( "testing".getBytes() ) );
        assertNotNull( source );
        assertTrue( source instanceof StreamSource );
    }
    
    @Test
    public void getSourceFile() throws IOException
    {
        final File file = File.createTempFile("junit", ".test");
        file.deleteOnExit();
        final Source source = factory.createSource(file);
        assertNotNull( source );
        assertTrue( source instanceof StreamSource );
        final StreamSource streamSource = (StreamSource) source;
        final InputStream inputStream = streamSource.getInputStream();
        assertTrue(inputStream instanceof BufferedInputStream);
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SourceFactoryUnitTest.class);
    }
    
}
