/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.transformation.xslt;

import static org.junit.Assert.*;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

import org.jboss.soa.esb.actions.transformation.xslt.ResultFactory.ResultType;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;

/**
 * Unit test for {@link ResultFactory}.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class ResultFactoryUnitTest
{
    private ResultFactory resultFactory = ResultFactory.getInstance();
    
    @Test
    public void createStringResult()
    {
        final Result result = resultFactory.createResult(ResultType.STRING);
        assertTrue(result instanceof StreamResult);
        final StreamResult streamResult = (StreamResult) result;
        assertNotNull(streamResult.getWriter());
        final Writer writer = streamResult.getWriter();
        assertTrue(writer instanceof StringWriter);
    }
    
    @Test
    public void createByteArrayResult()
    {
        final Result result = resultFactory.createResult(ResultType.BYTES);
        assertTrue(result instanceof StreamResult);
        final StreamResult streamResult = (StreamResult) result;
        assertNull(streamResult.getWriter());
        final OutputStream outputStream = streamResult.getOutputStream();
        assertNotNull(outputStream);
        assertNotNull(outputStream instanceof ByteArrayOutputStream);
    }
    
    @Test
    public void createDOMResult()
    {
        final Result result = resultFactory.createResult(ResultType.DOM);
        assertTrue(result instanceof DOMResult);
    }
    
    @Test
    public void createSAXResult()
    {
        final Result result = resultFactory.createResult(ResultType.SAX);
        assertTrue(result instanceof SAXResult);
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(ResultFactoryUnitTest.class);
    }
}
