/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.naming.strategy;

import java.net.URI;
import java.net.URISyntaxException;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;

import junit.framework.TestCase;

/**
 * Test the timestamp naming strategy.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 */
public class AddTimestampNamingStrategyUnitTest extends TestCase {
	private static String FILENAME = "word";
	private static String SUFFIX = "doc";

	private static Logger logger = Logger.getLogger(AddTimestampNamingStrategyUnitTest.class);
	
	public void testProcess() {
		AddTimestampNamingStrategy atns = new AddTimestampNamingStrategy();
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
		msg1.getBody().add("bar");
		try {
			msg1.getHeader().getCall().setTo(new HTTPEpr("http://foo.bar"));
			msg1.getHeader().getCall().setMessageID(new URI("urn:1234"));
		} catch (URISyntaxException e1) {
			e1.printStackTrace();
			fail(e1.getMessage());
		}
		
		String filename = atns.process(FILENAME + "."  + SUFFIX, msg1);
		logger.debug("Filename: [" + filename + "]");
		
		if (! filename.matches(FILENAME + "-[0-9]+." + SUFFIX)) {
			fail("Filename does not match filename-timestamp.suffix.");
		}
	}
}
