/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

import junit.framework.TestCase;

/**
 * Test for https://jira.jboss.org/browse/JBESB-3308.
 * 
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
 */
public class Aggregator_JBESB_3308_UnitTest extends TestCase {

	public void test_not_all_same_01() {
		List<Message> attachmentMessages = createMessages(5);
		Message aggregatedMessage = MessageFactory.getInstance().getMessage();
		
		// Modify one of the replyTos...
		attachmentMessages.get(4).getHeader().getCall().setReplyTo(new EPR(URI.create("xproto://someother/address")));
		
		// Map... shouldn't map a replyTo because they're not all the same...
		Aggregator.mapCallDetails(attachmentMessages, aggregatedMessage, "blah");
		
		assertNull(aggregatedMessage.getHeader().getCall().getReplyTo());
	}

	public void test_not_all_same_02() {
		List<Message> attachmentMessages = createMessages(5);
		Message aggregatedMessage = MessageFactory.getInstance().getMessage();
		
		// Modify one of the replyTos...
		attachmentMessages.get(4).getHeader().getCall().setReplyTo(null);
		
		// Map... shouldn't map a replyTo because they're not all the same...
		Aggregator.mapCallDetails(attachmentMessages, aggregatedMessage, "blah");
		
		assertNull(aggregatedMessage.getHeader().getCall().getReplyTo());
	}

	public void test_all_same() {
		List<Message> attachmentMessages = createMessages(5);
		Message aggregatedMessage = MessageFactory.getInstance().getMessage();
		
		// Map... should map a replyTo because they are all the same...
		Aggregator.mapCallDetails(attachmentMessages, aggregatedMessage, "blah");
		
		assertEquals(new EPR(URI.create("xproto://some/address")), aggregatedMessage.getHeader().getCall().getReplyTo());
	}

	
	
	private List<Message> createMessages(int numMessages) {
		List<Message> messages = new ArrayList<Message>();
		
		for(int i = 0; i < numMessages; i++) {
			messages.add(MessageFactory.getInstance().getMessage());
			Call call = new Call();
			call.setReplyTo(new EPR(URI.create("xproto://some/address")));
			messages.get(i).getHeader().setCall(call);
		}
		
		return messages;
	}
}
