/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.security;

import static org.junit.Assert.*;
import java.net.URL;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;


/**
 * Unit test for {@link SecurityContextPropagatorFactory}.
 * <p/>
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class SecurityContextPropagatorFactoryUnitTest
{
    // only used to store and restore a previously set configuration file.
    private String jbossEsbProperties;

    @Test
    public void create() throws SecurityServiceException
    {
        SecurityContextPropagator propagator = SecurityContextPropagatorFactory.create(JBossASContextPropagator.class.getName());
        assertTrue(propagator instanceof JBossASContextPropagator);
    }

    @Test
    public void createNullClassNameSpecified() throws SecurityServiceException
    {
        SecurityContextPropagator propagator = SecurityContextPropagatorFactory.create(null);
        assertNull(propagator);
    }

    @Test
    public void createFromConfig() throws SecurityServiceException
    {
        SecurityContextPropagator propagator = SecurityContextPropagatorFactory.createFromConfig();

        // should match the class specified in security-properties.xml (in this classes directory.
        assertTrue(propagator instanceof JBossASContextPropagator);
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SecurityContextPropagatorFactoryUnitTest.class);
    }

    @Before
    public void setup() throws ConfigurationException
    {
        // store jbossesb properties env variable value
        jbossEsbProperties = System.getProperty(Environment.PROPERTIES_FILE);

        URL resource = ClassUtil.getResource("security-properties.xml", getClass());
        System.setProperty(Environment.PROPERTIES_FILE, "abs://" + resource.getFile());
    }

    @After
    public void tearDown()
    {
        if ( jbossEsbProperties != null )
        {
            // restore jbossesb-properties variable
            System.setProperty(Environment.PROPERTIES_FILE, jbossEsbProperties);
        }
    }

}
