/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.RegistryInterceptor;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;


/**
 * Registry stats interceptor.
 * 
 * @author <a href="mailto:Kevin.Conner@jboss.com">Kevin Conner</a>
 */
class RegistryStatsInterceptor implements RegistryInterceptor
{
    private Registry registry ;
    final AtomicInteger findAllServicesCount = new AtomicInteger() ;
    final AtomicInteger findEPRCount = new AtomicInteger() ;
    final AtomicInteger findEPRsCount = new AtomicInteger() ;
    final AtomicInteger findServicesCount = new AtomicInteger() ;
    final AtomicInteger registerEPRCount = new AtomicInteger() ;
    final AtomicInteger unRegisterEPRCount = new AtomicInteger() ;
    final AtomicInteger unRegisterServiceCount = new AtomicInteger() ;
    
    public List<String> findAllServices()
        throws RegistryException
    {
        findAllServicesCount.incrementAndGet() ;
        return registry.findAllServices() ;
    }

    public int getFindAllServicesCount()
    {
        return findAllServicesCount.get() ;
    }

    public EPR findEPR(final String serviceCategoryName, final String serviceName)
        throws RegistryException, ServiceNotFoundException
    {
        findEPRCount.incrementAndGet() ;
        return registry.findEPR(serviceCategoryName, serviceName) ;
    }

    public int getFindEPRCount()
    {
        return findEPRCount.get() ;
    }

    public List<EPR> findEPRs(final String serviceCategoryName, final String serviceName)
        throws RegistryException, ServiceNotFoundException
    {
        findEPRsCount.incrementAndGet() ;
        return registry.findEPRs(serviceCategoryName, serviceName) ;
    }

    public int getFindEPRsCount()
    {
        return findEPRsCount.get() ;
    }

    public List<String> findServices(final String serviceCategoryName)
        throws RegistryException
    {
        findServicesCount.incrementAndGet() ;
        return registry.findServices(serviceCategoryName) ;
    }

    public int getFindServicesCount()
    {
        return findServicesCount.get();
    }

    public void registerEPR(final String serviceCategoryName, final String serviceName,
        final String serviceDescription, final EPR epr, final String eprDescription)
        throws RegistryException
    {
        registerEPRCount.incrementAndGet() ;
        registry.registerEPR(serviceCategoryName, serviceName, serviceDescription, epr, eprDescription) ;
    }

    public int getRegisterEPRCount()
    {
        return registerEPRCount.get();
    }

    public void unRegisterEPR(final String serviceCategoryName,
        final String serviceName, final EPR epr)
        throws RegistryException, ServiceNotFoundException
    {
        unRegisterEPRCount.incrementAndGet() ;
        registry.unRegisterEPR(serviceCategoryName, serviceName, epr) ;
    }

    public int getUnRegisterEPRCount()
    {
        return unRegisterEPRCount.get();
    }

    public void unRegisterService(final String category, final String serviceName)
        throws RegistryException, ServiceNotFoundException
    {
        unRegisterServiceCount.incrementAndGet() ;
        registry.unRegisterService(category, serviceName) ;
    }

    public int getUnRegisterServiceCount()
    {
        return unRegisterServiceCount.get();
    }

    public void setRegistry(final Registry registry)
    {
        this.registry = registry ;
    }
}
