/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;

import javax.transaction.Synchronization;
import javax.transaction.xa.XAResource;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MockTransactionStrategy extends TransactionStrategy {

    public static Object transactionObject;
    public static boolean isActive;

    public static void reset() {
        transactionObject = null;
        isActive = false;
    }

    public void begin() throws TransactionStrategyException {

    }

    public void terminate() throws TransactionStrategyException {

    }

    public void rollbackOnly() throws TransactionStrategyException {

    }

    public Object getTransaction() throws TransactionStrategyException {
        return transactionObject;
    }

    public Object suspend() throws TransactionStrategyException {
        try {
            return transactionObject;
        } finally {
            transactionObject = null;
            isActive = false;
        }
    }

    public boolean isActive() throws TransactionStrategyException {
        return isActive;
    }

    public void resume(Object tx) throws TransactionStrategyException {
        transactionObject = tx;
        isActive = true;
    }

    public void registerSynchronization(Synchronization sync) throws TransactionStrategyException {

    }

    public void enlistResource(XAResource resource) throws TransactionStrategyException {

    }
}
