/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.util;

import java.io.Serializable;

@SuppressWarnings("serial")
public class ObjLocator implements Serializable
{
  private long        m_lUid;
  private Object []   m_oaLocs;

  public  long        getUid() { return m_lUid; }
  public  String []   getStrings() { return (String []) m_oaLocs; }
  public int getColumnCount()
  { return (null == m_oaLocs) ? 0 : m_oaLocs.length;
  } //__________________________________

  public ObjLocator(long p_lUid, Object [] p_sa)
  { m_lUid    = p_lUid;
    m_oaLocs  = (null == p_sa) ? new Object [0] : p_sa;
    for (int i1=0; i1<m_oaLocs.length;i1++)
      if (null == m_oaLocs[i1]) m_oaLocs[i1]="";
  } //__________________________________

  public Object get(int p_iCol)
  { return (null == m_oaLocs) ? ""
        :(p_iCol < 0 || p_iCol >= m_oaLocs.length) ? ""
        : m_oaLocs[p_iCol];
  } //__________________________________

  public void set(int p_iCol, Object p_o)
  { if (null == m_oaLocs)                         return;
    if (p_iCol < 0 || p_iCol >= m_oaLocs.length)  return;
    m_oaLocs[p_iCol]    = p_o;
  } //__________________________________

  public boolean    equals(Object p_o)
  { return (p_o instanceof ObjLocator)
      ? m_lUid == ((ObjLocator)p_o).getUid()
      : false;
  } //__________________________________

  /**
   * Return a hash code for this element.
   * @return the element hash code.
   */
  @Override
  public int hashCode()
  {
      return (int)(m_lUid ^ (m_lUid >>> 32)) ;
  }

  public static ObjLocator find(long p_l, ObjLocator[] p_ola)
  { ObjLocator oRet;
    if (null != p_ola)
      for (int i1=0; i1<p_ola.length;i1++)
        if (p_l == (oRet = p_ola[i1]).getUid()) return oRet;
    return null;
  } //__________________________________

  public String toString()
  { StringBuffer sb = new StringBuffer(200);
    sb.append("ObjLocator: ").append(m_lUid).append(" <");
    for (int i1=0; i1<m_oaLocs.length;i1++)
    { if (i1 > 0) sb.append(" ");
      sb.append(m_oaLocs[i1].toString());
    }
    sb.append(">");
    return sb.toString();
  } //__________________________________

  public static long [] getUids(ObjLocator[] p_ola)
  { long [] laRet = new long [] {};
    if (null == p_ola)  return laRet;
    if (p_ola.length<1) return laRet;
    laRet = new long[p_ola.length];
    for (int i1=0; i1<laRet.length; i1++)
      laRet[i1] = p_ola[i1].getUid();

    return laRet;
  } //__________________________________

} //____________________________________________________________________________
