/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.login;

import java.io.IOException;
import java.util.Map;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

import org.jboss.internal.soa.esb.services.security.EsbCallbackHandler;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

public class CertCallbackHandler implements EsbCallbackHandler
{
    private String keyStoreAlias;
    private char[] keyPassword;
    private AuthenticationRequest authRequest;

    public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException
    {
        for (int i = 0; i < callbacks.length; i++)
        {
            if (callbacks[i] instanceof NameCallback)
            {
                NameCallback nameCallback = (NameCallback) callbacks[i];
                nameCallback.setName(keyStoreAlias);
            }
            else if (callbacks[i] instanceof PasswordCallback)
            {
                PasswordCallback passwordCallback = (PasswordCallback) callbacks[i];
                passwordCallback.setPassword(keyPassword);
            }
            else if (callbacks[i] instanceof ObjectCallback)
            {
                ObjectCallback objectCallback = (ObjectCallback) callbacks[i];
                objectCallback.setCredential(authRequest.getCredentials());
            }
        }
    }

    public void setAuthenticationRequest(AuthenticationRequest authRequest)
    {
        this.authRequest = authRequest;
    }

    public void setSecurityConfig(final SecurityConfig config)
    {
        if (config != null)
        {
            Map<String, String> properties = config.getProperties();
            this.keyStoreAlias = properties.get("alias");

            String keyPass = properties.get("keyPassword");
            if (keyPass != null)
                this.keyPassword = keyPass.toCharArray();

            keyPass = null;
        }
    }
}
