/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.util.ClassUtil;

public class SecurityServiceFactory
{
	private static Logger log = Logger.getLogger(SecurityServiceFactory.class);

	private static SecurityService instance;

	private SecurityServiceFactory() { }

	public static synchronized SecurityService getSecurityService() throws ConfigurationException
	{
		if (instance != null)
		{
			return instance;
		}

		String className = Configuration.getSecurityServiceImplementationClass();
		if ( className == null )
		{
			throw new ConfigurationException("No SecurityService implementation has been set. Please check the configuration");
		}

		SecurityService service = null;
		try
		{
			log.info("Using [" + className + "] as the SecurityService implementation.");
			Class<?> securityClass = ClassUtil.forName(className, SecurityService.class);
			service = (SecurityService) securityClass.newInstance();
			service.configure();
		}
		catch (ClassNotFoundException e)
		{
			throw new ConfigurationException("SecurityService Implementation=" + className + " not found", e);
		}
		catch (Exception e)
		{
			throw new ConfigurationException("Invocation exception. " + e.getLocalizedMessage(), e);
		}
		instance = service;
		return service;
	}

}
