/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners.message; 

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.common.Environment;

/**
 * ActionStatusBean is a bean which wraps the information necessary to update the
 * ServiceMessageCounter MBean.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.2
 */
public class ActionStatusBean {
	private int m_procCount;
	private String m_status;
	private long m_procTime;
	private long m_bytesProcessed;
	private long serviceTime;
	
	
	public static final String ACTION_SENT = "SENT";
	public static final String ACTION_FAILED = "FAILED";
	
	/**
	 * Constructor
	 * @param procTime processing time
	 * @param f_procCount counter that identifies the action processor in the ConfigTree
	 * @param f_status status string
	 * @param objectName object name of the ServiceMessageCounter
	 */
	public ActionStatusBean(long procTime, int f_procCount, Message f_message, String f_status, String objectName) {
		m_procTime = procTime;
		m_procCount = f_procCount;
		m_status = f_status;
		m_bytesProcessed = 0;
		serviceTime = 0;
		
		String timeLabel = objectName + "Time";
		try {
			String bytes = (String) f_message.getProperties().getProperty(Environment.MESSAGE_BYTE_SIZE);
			if (f_message.getProperties().getProperty(timeLabel) != null) {
				Long messageServiceTime = (Long) f_message.getProperties().getProperty(objectName + "Time");
				serviceTime = messageServiceTime.longValue() + procTime;
				f_message.getProperties().setProperty(timeLabel, new Long(serviceTime));
			} else {
				serviceTime = procTime;
				f_message.getProperties().setProperty(timeLabel, new Long(procTime));
			}
			m_bytesProcessed = Long.parseLong(bytes);
		} catch (NullPointerException npe) {			
		} catch (NumberFormatException nfe) {
		}
	}

	/**
	 * Processed bytes getter.
	 * @return bytes processed
	 */
	public long getBytesProcessed() {
		return m_bytesProcessed;
	}
	
	/**
	 * Process counter getter.
	 * @return counter that identifies the action processor in the ConfigTree
	 */
	public int getProcCount() {
		return m_procCount;
	}
	
	/**
	 * Status getter.
	 * @return status of action process
	 */
	public String getStatus() {
		return m_status;
	}
	
	/**
	 * Action processing Time getter.
	 * @return processing time elapsed
	 */
	public long getProcTime() {
		return m_procTime;
	}

	/**
	 * Service processing Time getter.
	 * @return processing time elapsed
	 */
	public long getServiceTime() {
		return serviceTime;
	}
}
