/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.soa.esb.listeners.ha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.jboss.soa.esb.addressing.EPR;

/**
 * Default implementation of ServiceClusterInfo.
 * 
 * Holder for a list of eprs all belonging to the same service.
 * 
 * Code based on jbossas ha framework.
 *  
 * @author <a href="mailto:kurt@osconsulting.org">Kurt Stam</a>.
 *
 */
public class ServiceClusterInfoImpl implements ServiceClusterInfo
{
   public String serviceName = null;
   ArrayList<EPR> eprs = null;
   
   int cursor = ServiceClusterInfo.UNINITIALIZED_CURSOR;
   
   public ServiceClusterInfoImpl (String serviceName, List<EPR> eprs)
   {
       this.serviceName = serviceName;
       this.eprs = cloneList(eprs);
   }
   /**
    * Returns the ServiceName.
    */
   public String getServiceName () { return this.serviceName; }
   /**
    * Returns an unmodifiable view of the target list.
    */
   public synchronized List<EPR> getEPRs () 
   { 
      return Collections.unmodifiableList(this.eprs);
   }
 
   public int getCursor () { return this.cursor; }
   public int setCursor (int cursor) { return (this.cursor = cursor);}
   
   @SuppressWarnings("unchecked")
   public List<EPR> removeDeadEPR(EPR epr)
   {
      synchronized (this)
      {
         ArrayList<EPR> tmp = (ArrayList<EPR>) eprs.clone();
         tmp.remove (epr);
         this.eprs = tmp;
         
         return Collections.unmodifiableList(this.eprs);
      }      
   }
   
   public List<EPR> updateClusterInfo (List<EPR> eprs)
   {
      synchronized (this)
      {
         this.eprs = cloneList(eprs);
         return Collections.unmodifiableList(this.eprs);
      }
   }

   public String toString()
   {
      StringBuffer tmp = new StringBuffer(super.toString());
      tmp.append("serviceName=");
      tmp.append(serviceName);
      tmp.append("eprs=");
      tmp.append(eprs);
      tmp.append(",cursor=");
      tmp.append(cursor);
      tmp.append("}");
      return tmp.toString();
   }

   @SuppressWarnings("unchecked")
   private static ArrayList<EPR> cloneList(List<EPR> toClone)
   {
      if (toClone instanceof ArrayList)
      {
      	 synchronized (toClone)
      	 {
         	return (ArrayList<EPR>) ((ArrayList<EPR>) toClone).clone();
         }
      }
      
      ArrayList<EPR> clone = new ArrayList<EPR>(toClone.size());
      synchronized (toClone)
      {
      	clone.addAll(toClone);
      }
      return clone;      
   }
}
