/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.config;

import java.util.Properties;

/**
 * Common information used to configure an action
 *
 * @author <a href="kevin.conner@jboss.com">Kevin Conner</a>
 */
public class Action
{
    /**
     * The action name attribute.
     */
    private final String nameAttribute ;
    /**
     * The action class attribute.
     */
    private final String classAttribute ;
    /**
     * The action process attribute.
     */
    private final String processAttribute ;
    /**
     * The action properties.
     */
    private final Properties properties ;
    
    /**
     * Create the common action information.
     * 
     * @param nameAttribute The name attribute.
     * @param classAttribute The class attribute.
     * @param processAttribute The process attribute.
     * @param properties The properties.
     */
    public Action(final String nameAttribute, final String classAttribute,
        final String processAttribute, final Properties properties)
    {
        this.nameAttribute = nameAttribute ;
        this.classAttribute = classAttribute ;
        this.processAttribute = processAttribute ;
        this.properties = properties ;
    }
    
    /**
     * Get the action name attribute.
     * @return The name attribute.
     */
    public String getNameAttribute()
    {
        return nameAttribute ;
    }
    
    /**
     * Get the action class attribute.
     * @return The class attribute.
     */
    public String getClassAttribute()
    {
        return classAttribute ;
    }
    
    /**
     * Get the action process attribute.
     * @return The process attribute.
     */
    public String getProcessAttribute()
    {
        return processAttribute ;
    }
    
    /**
     * Get the action properties.
     * @return The properties.
     */
    public Properties getProperties()
    {
        return properties ;
    }
}
