/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.http;

import org.apache.commons.httpclient.ConnectionPoolTimeoutException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.protocol.Protocol;

/**
 * Connection manager which overrides the host configuration.
 * @author kevin
 */
public class ESBMultiThreadedHttpConnectionManager extends
    MultiThreadedHttpConnectionManager
{
    private HostConfiguration hostConfiguration ;
    private String scheme ;
    
    public void setHostConfiguration(final HostConfiguration hostConfiguration)
    {
        this.hostConfiguration = hostConfiguration ;
        
        scheme = null ;
        if (hostConfiguration != null)
        {
            final Protocol protocol = hostConfiguration.getProtocol() ;
            if (protocol != null)
            {
                scheme = protocol.getScheme() ;
            }
        }
    }
    
    public HostConfiguration getHostConfiguration()
    {
        return hostConfiguration ;
    }
    
    @Override
    public HttpConnection getConnection(final HostConfiguration hostConfiguration)
    {
        return super.getConnection(getHostConfiguration(hostConfiguration)) ;
    }
    
    @Override
    public HttpConnection getConnection(final HostConfiguration hostConfiguration, final long timeout)
        throws HttpException
    {
        return super.getConnection(getHostConfiguration(hostConfiguration), timeout) ;
    }
    
    @Override
    public HttpConnection getConnectionWithTimeout(final HostConfiguration hostConfiguration, final long timeout)
        throws ConnectionPoolTimeoutException
    {
        return super.getConnectionWithTimeout(getHostConfiguration(hostConfiguration), timeout) ;
    }
    
    @Override
    public int getConnectionsInPool(final HostConfiguration hostConfiguration)
    {
        return super.getConnectionsInPool(getHostConfiguration(hostConfiguration));
    }

    @Override
    public int getConnectionsInUse(final HostConfiguration hostConfiguration)
    {
        return super.getConnectionsInUse(getHostConfiguration(hostConfiguration));
    }
    
    private HostConfiguration getHostConfiguration(final HostConfiguration hostConfiguration)
    {
        if (this.hostConfiguration != null)
        {
            // If we are the same scheme than make sure we use our socket factory
            if ((scheme != null) && scheme.equals(hostConfiguration.getProtocol().getScheme()))
            {
                final HostConfiguration newConfiguration = new HostConfiguration(hostConfiguration) ;
                final String host = hostConfiguration.getHost() ;
                final int port = hostConfiguration.getPort() ;
                newConfiguration.setHost(host, port, this.hostConfiguration.getProtocol()) ;
                return newConfiguration ;
            }
        }
        return hostConfiguration ;
    }
}
