/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions.converters;

import java.util.List;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;

/**
 * Abstract object and xstream action processor for common functionality. 
 * 
 * 
 * @author danielmarchant
 *
 */
public abstract class AbstractObjectXStream extends AbstractActionPipelineProcessor {
	
	
	protected String classAlias;
	protected String rootNodeName;
	protected boolean excludePackage = true;
	protected String classMethod;
    protected Class processorClass;
	protected String classProcessor;
	private String name;
		 
	    
    /**
     * Public constructor.
     * @param properties Action Properties.
     * @throws ConfigurationException Action not properly configured.
     */
    protected AbstractObjectXStream(ConfigTree properties) {
    	this( properties.getName(), properties.attributesAsList());
    }
	    
    /**
     * Public constructor.
     * @param actionName Action name.
     * @param properties Action Properties.
     * @throws ConfigurationException Action not properly configured.
     */
    public AbstractObjectXStream(String actionName, List<KeyValuePair> properties) {
    	name = actionName;
    	classAlias = KeyValuePair.getValue("class-alias", properties, null);
        excludePackage = KeyValuePair.getBooleanValue("exclude-package", properties, true);
        rootNodeName = KeyValuePair.getValue("root-node", properties, null );
    }
	
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	

	/**
	 * Gets the alias to use with classes.
	 * 
	 * @param obj
	 * @return String
	 */
	protected String getAlias(Object obj) {
		if(classAlias == null) {
            if(excludePackage) {
                return (obj instanceof Class) ? ((Class)obj).getSimpleName() : obj.getClass().getSimpleName();
            } else {
               return (obj instanceof Class) ? ((Class)obj).getName() : obj.getClass().getName();
            }
        } 
		return classAlias;
	}

	public String getRootNodeName()
	{
		return rootNodeName;
	}

}
