package org.jboss.soa.esb;

/**
 * Base ESB Exception.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class BaseException extends Exception {

	private static final long serialVersionUID = 1L;

	/**
	 * Public Default Constructor.
	 */
	public BaseException() {
		super();
	}

	/**
	 * Public Constructor.
	 * @param message Exception message.
	 */
	public BaseException(String message) {
		super(message);
	}

	/**
	 * Public Constructor.
	 * @param message Exception message.
	 * @param cause Exception cause.
	 */
	public BaseException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Public Constructor.
	 * @param cause Exception cause.
	 */
	public BaseException(Throwable cause) {
		super(cause);
	}
}
