/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.webservice.addressing.def;

import javax.xml.namespace.QName;

import org.jboss.internal.soa.esb.webservice.addressing.MAPRelatesTo;

/**
 * 
 * @author Andrew Dinn - adinn@redhat.com
 * @author alessio.soldano@jboss.com
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */
public class NativeMAPRelatesTo implements MAPRelatesTo
{
   private String relatesTo;
   private QName type;

   NativeMAPRelatesTo(String relatesTo, QName type)
   {
      this.relatesTo = relatesTo;
      this.type = type;
   }

   public String getRelatesTo()
   {
      return relatesTo;
   }

   public QName getType()
   {
      return type;
   }

   public void setType(QName type)
   {
      this.type = type;
   }
}
