/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.events;

import javax.xml.stream.Location;

/**
 * Cached Location information for events..
 */
public class ESBStaxLocation implements Location
{
    private final int characterOffset ;
    private final int columnNumber ;
    private final int lineNumber ;
    private final String publicId ;
    private final String systemId ;

    public ESBStaxLocation(final Location location)
    {
        characterOffset = location.getCharacterOffset() ;
        columnNumber = location.getColumnNumber() ;
        lineNumber = location.getLineNumber() ;
        publicId = location.getPublicId() ;
        systemId = location.getSystemId() ;
    }

    public int getCharacterOffset()
    {
        return characterOffset ;
    }

    public int getColumnNumber()
    {
        return columnNumber ;
    }

    public int getLineNumber()
    {
        return lineNumber ;
    }

    public String getPublicId()
    {
        return publicId ;
    }

    public String getSystemId()
    {
        return systemId ;
    }
}
