/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import java.util.concurrent.atomic.AtomicBoolean;

import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

/**
 * Wrapped topic subscriber class.
 */
class WrappedTopicSubscriber extends WrappedMessageConsumer implements TopicSubscriber
{
    /**
     * The topic subscriber.
     */
    private final TopicSubscriber topicSubscriber ;

    /**
     * Construct the wrapped topic subscriber.
     * @param connectionPool The connection pool associated with the session.
     * @param jmsSession The session associated with the subscriber.
     * @param topicSubscriber The topic subscriber.
     */
    public WrappedTopicSubscriber(final JmsConnectionPool connectionPool,
        final JmsSession jmsSession, final TopicSubscriber topicSubscriber)
    {
        super(connectionPool, jmsSession, topicSubscriber) ;
        this.topicSubscriber = topicSubscriber ;
    }

    /**
     * Construct the wrapped topic subscriber.
     * @param connectionPool The connection pool associated with the session.
     * @param jmsSession The session associated with the subscriber.
     * @param topicSubscriber The topic subscriber.
     * @param wrapperValid valid flag for xa associations.
     */
    public WrappedTopicSubscriber(final JmsConnectionPool connectionPool,
        final JmsSession jmsSession, final TopicSubscriber topicSubscriber,
        final AtomicBoolean wrapperValid)
    {
        super(connectionPool, jmsSession, topicSubscriber, wrapperValid) ;
        this.topicSubscriber = topicSubscriber ;
    }

    public boolean getNoLocal()
        throws JMSException
    {
        associate() ;
        try
        {
            return topicSubscriber.getNoLocal() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }

    public Topic getTopic()
        throws JMSException
    {
        associate() ;
        try
        {
            return topicSubscriber.getTopic() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }
}
