/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author schifest@heuristica.com.ar
 */
package org.jboss.internal.soa.esb.message.format.serialized;

import java.io.Serializable;
import java.util.Hashtable;

import org.jboss.soa.esb.message.Properties;

public class PropertiesImpl implements Properties, Serializable
{
	private static final long serialVersionUID = 0x0;

	public synchronized Object getProperty(String name)
	{
		return SerializedValueImpl.unwrap(_table.get(name));
	}

	public Object getProperty(String name, Object defaultVal)
	{
		Object oRet = getProperty(name);
		return (null == oRet) ? defaultVal : oRet;
	}

	public Object setProperty(String name, Object value)
	{
		if (value instanceof Serializable)
		{
                    final Serializable wrapped = SerializedValueImpl.wrap((Serializable)value) ;
                    synchronized(this)
                    {
                        final Serializable previous = _table.put(name, wrapped) ;
                        return SerializedValueImpl.unwrap(previous);
                    }
		}
		else
			throw new IllegalArgumentException("Value must be serializable");
	}

	public synchronized Object remove(String name)
	{
		return SerializedValueImpl.unwrap(_table.remove(name));
	}
	
	public synchronized int size() {return _table.size(); } 

	public synchronized String[] getNames()
	{
		return _table.keySet().toArray(new String[0]);
	}

	public synchronized String toString()
	{
		return "properties: [ "+_table.toString()+" ]";
	}

	private Hashtable<String, Serializable> _table = new Hashtable<String, Serializable>();
}
