/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.internal.soa.esb.listeners.war;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.internal.soa.esb.listeners.war.HttpGatewayDeploymentFactory;
import org.jboss.logging.Logger;

/**
 * Web Gateway Deployment Factory.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public interface WebGatewayDeploymentFactory {

    /**
     * Update the {@link WebModel} based on the supplied web endpoint configuration.
     * @param deploymentName The ESB deployment name.
     * @param webEndpointConfig The web endpoint configuration.
     * @param webModel The Web Model to be updated.
     * @return The deployment archives.
     * @throws ConfigurationException Failed to create the Deployment Archives. 
     */
    public void updateWebModel(final String deploymentName, ConfigTree webEndpointConfig, WebModel webModel) throws ConfigurationException;

    /**
     * Factory builder.
     */
    public static class FactoryBuilder {

        private final static Logger logger = Logger.getLogger(FactoryBuilder.class);

        public static WebGatewayDeploymentFactory createInstance(String gatewayClass) {

            // Intentionally not allowing specification of the implementation.  Was deemed
            // too risky.  Must be an internally defined implementation.
            if(HttpGatewayDeploymentFactory.class.getName().equals(gatewayClass)) {
                return new HttpGatewayDeploymentFactory();
            }
            
            logger.debug("Not creating a WebGatewayDeploymentFactory instance for '" + gatewayClass + "'.  Not an internally defined WebGatewayDeploymentFactory implementation.");

            return null;
        }
    }
}
