/*
 * Copyright 2001-2008 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */


package org.apache.juddi.v3.client;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDIReplicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;
import org.uddi.v3_service.UDDIValueSetCachingPortType;
import org.uddi.v3_service.UDDIValueSetValidationPortType;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.5-b03-
 * Generated source version: 2.1
 * 
 */
@WebServiceClient(name = "UDDI_Service", targetNamespace = "urn:uddi-org:v3_service", wsdlLocation = "classpath:/uddi_v3_service.wsdl")
public class UDDIService
    extends Service
{

    private final static URL UDDISERVICE_WSDL_LOCATION;
   
    static {
        URL url = ClassUtil.getResource("uddi_v3_service.wsdl",UDDIService.class);
        UDDISERVICE_WSDL_LOCATION = url;
    }

    public UDDIService(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }
    
    public UDDIService(URL wsdlLocation) {
    	super(wsdlLocation, new QName("urn:uddi-org:v3_service", "UDDI_Service"));
    }

    public UDDIService() {
        super(UDDISERVICE_WSDL_LOCATION, new QName("urn:uddi-org:v3_service", "UDDI_Service"));
    }

    /**
     * 
     * @return
     *     returns UDDIInquiryPortType
     */
    @WebEndpoint(name = "UDDI_Inquiry_Port")
    public UDDIInquiryPortType getUDDIInquiryPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Inquiry_Port"), UDDIInquiryPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDIInquiryPortType
     */
    @WebEndpoint(name = "UDDI_Inquiry_Port")
    public UDDIInquiryPortType getUDDIInquiryPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Inquiry_Port"), UDDIInquiryPortType.class, features);
    }

    /**
     * 
     * @return
     *     returns UDDIPublicationPortType
     */
    @WebEndpoint(name = "UDDI_Publication_Port")
    public UDDIPublicationPortType getUDDIPublicationPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Publication_Port"), UDDIPublicationPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDIPublicationPortType
     */
    @WebEndpoint(name = "UDDI_Publication_Port")
    public UDDIPublicationPortType getUDDIPublicationPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Publication_Port"), UDDIPublicationPortType.class, features);
    }

    /**
     * 
     * @return
     *     returns UDDISecurityPortType
     */
    @WebEndpoint(name = "UDDI_Security_Port")
    public UDDISecurityPortType getUDDISecurityPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Security_Port"), UDDISecurityPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDISecurityPortType
     */
    @WebEndpoint(name = "UDDI_Security_Port")
    public UDDISecurityPortType getUDDISecurityPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Security_Port"), UDDISecurityPortType.class, features);
    }

    /**
     * 
     * @return
     *     returns UDDICustodyTransferPortType
     */
    @WebEndpoint(name = "UDDI_Custody_Port")
    public UDDICustodyTransferPortType getUDDICustodyPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Custody_Port"), UDDICustodyTransferPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDICustodyTransferPortType
     */
    @WebEndpoint(name = "UDDI_Custody_Port")
    public UDDICustodyTransferPortType getUDDICustodyPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Custody_Port"), UDDICustodyTransferPortType.class, features);
    }

    /**
     * 
     * @return
     *     returns UDDIReplicationPortType
     */
    @WebEndpoint(name = "UDDI_Replication_Port")
    public UDDIReplicationPortType getUDDIReplicationPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Replication_Port"), UDDIReplicationPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDIReplicationPortType
     */
    @WebEndpoint(name = "UDDI_Replication_Port")
    public UDDIReplicationPortType getUDDIReplicationPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Replication_Port"), UDDIReplicationPortType.class, features);
    }

    /**
     * 
     * @return
     *     returns UDDISubscriptionPortType
     */
    @WebEndpoint(name = "UDDI_Subscription_Port")
    public UDDISubscriptionPortType getUDDISubscriptionPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Subscription_Port"), UDDISubscriptionPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDISubscriptionPortType
     */
    @WebEndpoint(name = "UDDI_Subscription_Port")
    public UDDISubscriptionPortType getUDDISubscriptionPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_Subscription_Port"), UDDISubscriptionPortType.class, features);
    }

    /**
     * 
     * @return
     *     returns UDDISubscriptionListenerPortType
     */
    @WebEndpoint(name = "UDDI_SubscriptionListener_Port")
    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_SubscriptionListener_Port"), UDDISubscriptionListenerPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDISubscriptionListenerPortType
     */
    @WebEndpoint(name = "UDDI_SubscriptionListener_Port")
    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_SubscriptionListener_Port"), UDDISubscriptionListenerPortType.class, features);
    }

    /**
     * 
     * @return
     *     returns UDDIValueSetValidationPortType
     */
    @WebEndpoint(name = "UDDI_ValueSetValidation_Port")
    public UDDIValueSetValidationPortType getUDDIValueSetValidationPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_ValueSetValidation_Port"), UDDIValueSetValidationPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDIValueSetValidationPortType
     */
    @WebEndpoint(name = "UDDI_ValueSetValidation_Port")
    public UDDIValueSetValidationPortType getUDDIValueSetValidationPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_ValueSetValidation_Port"), UDDIValueSetValidationPortType.class, features);
    }

    /**
     * 
     * @return
     *     returns UDDIValueSetCachingPortType
     */
    @WebEndpoint(name = "UDDI_ValueSetCaching_Port")
    public UDDIValueSetCachingPortType getUDDIValueSetCachingPort() {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_ValueSetCaching_Port"), UDDIValueSetCachingPortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns UDDIValueSetCachingPortType
     */
    @WebEndpoint(name = "UDDI_ValueSetCaching_Port")
    public UDDIValueSetCachingPortType getUDDIValueSetCachingPort(WebServiceFeature... features) {
        return super.getPort(new QName("urn:uddi-org:v3_service", "UDDI_ValueSetCaching_Port"), UDDIValueSetCachingPortType.class, features);
    }

}
