/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.esb;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the ESB simple_esb_proxy_invoke sample.
 */
public class QuickstartSimpleESBProxyInvoke2TestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_simple_esb_proxy_invoke2";

	public QuickstartSimpleESBProxyInvoke2TestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		if (System.getProperty("ws.stack","native").equals("native")) {
			return(new RiftSawTestSetup(QuickstartSimpleESBProxyInvoke2TestCase.class,
						TEST_NAME, "Quickstart_simple_esb_proxy_invoke2-1.jar,Quickstart_simple_esb_proxy_invoke2.war,Quickstart_simple_esb_proxy_invoke2-service.esb"));
		} else {
			return(new junit.framework.TestSuite());
		}
	}

	public void testSendHello() throws Exception {
		String result=sendSOAPMessage("hello_request1.xml",
					"http://localhost:8080/Quickstart_bpel_simple_invokeWS");
		
		result = processResult(result);

		assertMessageFromFile(result, "hello_response1.xml");
	}
}
