UPDATE ODE_SCHEMA_VERSION SET VERSION = 220;

DROP TABLE ODE_JOB;

CREATE TABLE ODE_JOB (
  jobid varchar(64)  NOT NULL,
  ts BIGINT  NOT NULL,
  nodeid varchar(64),
  scheduled smallint  NOT NULL,
  transacted smallint  NOT NULL,

  instanceId BIGINT,
  mexId varchar(255),
  processId varchar(255),
  type varchar(255),
  channel varchar(255),
  correlatorId varchar(255),
  correlationKeySet varchar(255),
  retryCount integer,
  inMem smallint,
  detailsExt blob(4096),

  PRIMARY KEY(jobid));

CREATE INDEX IDX_ODE_JOB_TS ON ODE_JOB(ts);
CREATE INDEX IDX_ODE_JOB_NODEID ON ODE_JOB(nodeid);

create table BPAF_EVENT (
    EID bigint generated by default as identity,
    ACTIVITY_DEFINITION_ID varchar(255),
    ACTIVITY_INSTANCE_ID varchar(255),
    ACTIVITY_NAME varchar(255),
    CURRENT_STATE varchar(255),
    PREVIOUS_STATE varchar(255),
    PROCESS_DEFINITION_ID varchar(255),
    PROCESS_INSTANCE_ID varchar(255),
    PROCESS_NAME varchar(255),
    SERVER_ID varchar(255),
    TIMESTAMP bigint,
    primary key (EID)
    );

create table BPAF_EVENT_DATA (
    TID bigint generated by default as identity,
    NAME varchar(255),
    VALUE varchar(255),
    EVENT_ID bigint,
    primary key (TID)
);

alter table BPAF_EVENT_DATA
    add constraint FK3E83D1BCDA848C8
    foreign key (EVENT_ID)
    references BPAF_EVENT;