/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.server.jbossas6;

import org.jboss.soa.dsp.server.ServerConfig;


/**
 * Factory to container independent config
 *
 * @author Thomas.Diesler@jboss.org
 * @author Heiko.Braun@jboss.com
 * 
 * @since 08-May-2006
 */
public class JBossServerConfigFactory implements org.jboss.soa.dsp.server.ServerConfigFactory
{
	  /** The default bean name */
	public static String BEAN_NAME = "org.jboss.soa.dsp:service=ServerConfig";
	  
   public static ServerConfig createServerConfig()
   {
     return new KernelAwareSPIFactory().getKernelProvidedSPI(
       BEAN_NAME, JBossServerConfig.class  
     );
   }
   
   public ServerConfig getServerConfig() {
	   return(createServerConfig());
   }
}