/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.ws;


import javax.xml.soap.*;
import javax.xml.ws.Provider;


/**
 * CXF requires the JAX-WS implementation class to directly implement the
 * Provider<SOAPMessage>, rather than be derived from a superclass that
 * implements it. Therefore this 'template' web service endpoint class
 * has been created, which will be loaded by javassist and renamed to
 * be the specific endpoint implementation. This is necessary as
 * javassist does not provide a way to set a interface that uses generics.
 *
 * @see org.jboss.soa.dsp.ws.WebServiceProviderGenerator
 *
 */
public class TemplateWebServiceEndpoint extends BaseWebServiceEndpoint implements Provider<SOAPMessage>
{
	// See RIFTSAW-123 for description of issue related to CXF
}
