/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.deployer;

import java.net.URL;

import org.jboss.soa.dsp.EndpointMetaData;
import org.jboss.soa.dsp.ServiceEndpointReference;
import org.jboss.soa.dsp.server.ServerConfig;
import org.jboss.soa.dsp.ws.BuildProcessor;

/**
 * This interface represents a service deployer.
 *
 */
public interface ServiceDeployer {

	/**
	 * This method is used to deploy a servicer within a target environment.
	 * 
	 * @param metaData The service endpoint metadata
	 * @param providerImpl The service provider implementation
	 * @param serviceUrl The service endpoint URL
	 * @param classLoader The classloader used in creation of the service provider implementation
	 * @param deployment The deployment archive containing service artifacts
	 * @param serverConfig The server configuration
	 * @return The service endpoint reference
	 * @throws Exception Failed to deploy the service
	 */
	public ServiceEndpointReference deploy(EndpointMetaData metaData, Class<?> providerImpl, URL serviceUrl,
						ClassLoader classLoader, java.io.File deployment, ServerConfig serverConfig)
							throws Exception;
	
	/**
	 * This method undeploys the service associated with the supplied endpoint reference.
	 * 
	 * @param ref The service endpoint reference
	 * @param serverConfig The server configuration
	 * @throws Exception
	 */
	public void undeploy(ServiceEndpointReference ref, ServerConfig serverConfig) throws Exception;
	
	/**
	 * This method returns the optional build processor associated with the
	 * service deployer. This build processor can be used to perform any
	 * platform specific deployment archive modifications prior to it being
	 * deployed to the target platform.
	 * 
	 * @return The optional build processor
	 */
	public BuildProcessor getBuildProcessor();
	
}
