/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TokenResolver {
    private static Logger log = Logger.getLogger(TokenResolver.class);

    public static synchronized String replaceTokens(String string, Properties properties) {
        if (properties == null || string == null) {
            return string;
        }
        string = string.replaceAll("\\n", " ").replaceAll("\\r", "");
        Pattern pattern = Pattern.compile("(?m)\\$\\{.*?\\}");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String token = matcher.group();
            String replacement = properties.getProperty(token = token.substring(2, token.length() - 1));
            if (replacement != null) {
                log.debug((Object)("Found token " + token + " and replacement value " + replacement));
                string = string.replaceAll("\\$\\{" + token + "\\}", replacement);
                continue;
            }
            log.error((Object)("Found token " + token + " but could not obtain its value. Data: " + string));
        }
        log.debug((Object)("Data after token replacement: " + string));
        return string;
    }
}

