/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.mockejb.jms.MockDestination;

class MockProducer
implements MessageProducer {
    private MockDestination destination;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private static int messageId = 1;

    MockProducer(MockDestination destination) {
        this.destination = destination;
    }

    public void send(Message msg) throws JMSException {
        this.send(msg, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination(false);
        MockProducer.sendMessage((MockDestination)this.getDestination(), msg, deliveryMode, priority, timeToLive);
    }

    protected static synchronized int getMessageId() {
        return messageId++;
    }

    protected static void sendMessage(MockDestination destination, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        msg.setJMSMessageID("ID:MockMessage " + MockProducer.getMessageId());
        msg.setJMSDestination((Destination)destination);
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSPriority(priority);
        msg.setJMSTimestamp(System.currentTimeMillis());
        if (timeToLive == 0L) {
            msg.setJMSExpiration(0L);
        } else {
            msg.setJMSExpiration(msg.getJMSTimestamp() + timeToLive);
        }
        destination.addMessage(msg);
    }

    public void send(Destination destination, Message msg) throws JMSException {
        this.send(destination, msg, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Destination destination, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination(true);
        if (destination instanceof MockDestination) {
            MockProducer.sendMessage((MockDestination)destination, msg, deliveryMode, priority, timeToLive);
        }
        throw new InvalidDestinationException("Invalid destination specified!");
    }

    public Destination getDestination() throws JMSException {
        return this.destination;
    }

    public void close() throws JMSException {
    }

    public void setDisableMessageID(boolean arg0) throws JMSException {
    }

    public boolean getDisableMessageID() throws JMSException {
        return false;
    }

    public void setDisableMessageTimestamp(boolean arg0) throws JMSException {
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return false;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public int getPriority() throws JMSException {
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        return this.timeToLive;
    }

    protected void checkDestination(boolean unidentifiedDestinationCheck) {
        if (unidentifiedDestinationCheck ? this.destination != null : this.destination == null) {
            throw new UnsupportedOperationException();
        }
    }
}

