/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.hibernate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.util.JDBCExceptionReporter;
import org.jbpm.JbpmException;
import org.jbpm.identity.hibernate.IdentitySessionFactory;

public class IdentitySchema {
    private static final String IDENTITY_TABLE_PREFIX = "JBPM_ID_";
    Configuration configuration = null;
    Properties properties = null;
    Dialect dialect = null;
    Mapping mapping = null;
    String[] createSql = null;
    String[] dropSql = null;
    String[] cleanSql = null;
    ConnectionProvider connectionProvider = null;
    Connection connection = null;
    Statement statement = null;
    private static String sqlDelimiter = null;
    private static final Log log = LogFactory.getLog((Class)IdentitySchema.class);

    public IdentitySchema(Configuration configuration) {
        this.configuration = configuration;
        this.properties = configuration.getProperties();
        this.dialect = Dialect.getDialect((Properties)this.properties);
        try {
            Field mappingField = Configuration.class.getDeclaredField("mapping");
            mappingField.setAccessible(true);
            this.mapping = (Mapping)mappingField.get(configuration);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get the hibernate mapping", (Throwable)e);
        }
    }

    public String[] getCreateSql() {
        if (this.createSql == null) {
            this.createSql = this.configuration.generateSchemaCreationScript(this.dialect);
        }
        return this.createSql;
    }

    public String[] getDropSql() {
        if (this.dropSql == null) {
            this.dropSql = this.configuration.generateDropSchemaScript(this.dialect);
        }
        return this.dropSql;
    }

    public String[] getCleanSql() {
        if (this.cleanSql == null) {
            ArrayList<String> dropForeignKeysSql = new ArrayList<String>();
            ArrayList<String> createForeignKeysSql = new ArrayList<String>();
            Iterator iter = this.configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    dropForeignKeysSql.add(fk.sqlDropString(this.dialect, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
                    createForeignKeysSql.add(fk.sqlCreateString(this.dialect, this.mapping, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
                }
            }
            ArrayList<String> deleteSql = new ArrayList<String>();
            iter = this.configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                deleteSql.add("delete from " + table.getName());
            }
            ArrayList<String> cleanSqlList = new ArrayList<String>();
            cleanSqlList.addAll(dropForeignKeysSql);
            cleanSqlList.addAll(deleteSql);
            cleanSqlList.addAll(createForeignKeysSql);
            this.cleanSql = cleanSqlList.toArray(new String[cleanSqlList.size()]);
        }
        return this.cleanSql;
    }

    public boolean hasIdentityTables() {
        return this.getIdentityTables().size() > 0;
    }

    public List getIdentityTables() {
        ArrayList<String> jbpmTableNames = new ArrayList<String>();
        try {
            this.createConnection();
            ResultSet resultSet = this.connection.getMetaData().getTables("", "", null, null);
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                if (tableName == null || tableName.length() <= 5 || !IDENTITY_TABLE_PREFIX.equalsIgnoreCase(tableName.substring(0, 5))) continue;
                jbpmTableNames.add(tableName);
            }
        }
        catch (SQLException e) {
            throw new JbpmException("couldn't get the jbpm table names");
        }
        finally {
            this.closeConnection();
        }
        return jbpmTableNames;
    }

    public void dropSchema() {
        this.execute(this.getDropSql());
    }

    public void createSchema() {
        this.execute(this.getCreateSql());
    }

    public void cleanSchema() {
        this.execute(this.getCleanSql());
    }

    public void saveSqlScripts(String dir, String prefix) {
        try {
            new File(dir).mkdirs();
            this.saveSqlScript(dir + "/" + prefix + ".drop.sql", this.getDropSql());
            this.saveSqlScript(dir + "/" + prefix + ".create.sql", this.getCreateSql());
            this.saveSqlScript(dir + "/" + prefix + ".clean.sql", this.getCleanSql());
            new SchemaExport(this.configuration).setDelimiter(this.getSqlDelimiter()).setOutputFile(dir + "/" + prefix + ".drop.create.sql").create(true, false);
        }
        catch (IOException e) {
            throw new JbpmException("couldn't generate scripts", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            IdentitySchema.syntax();
        } else if ("create".equalsIgnoreCase(args[0])) {
            new IdentitySchema(IdentitySessionFactory.createConfiguration()).createSchema();
        } else if ("drop".equalsIgnoreCase(args[0])) {
            new IdentitySchema(IdentitySessionFactory.createConfiguration()).dropSchema();
        } else if ("clean".equalsIgnoreCase(args[0])) {
            new IdentitySchema(IdentitySessionFactory.createConfiguration()).cleanSchema();
        } else if ("scripts".equalsIgnoreCase(args[0]) && args.length == 3) {
            new IdentitySchema(IdentitySessionFactory.createConfiguration()).saveSqlScripts(args[1], args[2]);
        } else {
            IdentitySchema.syntax();
        }
    }

    private static void syntax() {
        System.err.println("syntax:");
        System.err.println("IdentitySchema create");
        System.err.println("IdentitySchema drop");
        System.err.println("IdentitySchema clean");
        System.err.println("IdentitySchema scripts <dir> <prefix>");
    }

    private void saveSqlScript(String fileName, String[] sql) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        PrintStream printStream = new PrintStream(fileOutputStream);
        for (int i = 0; i < sql.length; ++i) {
            printStream.println(sql[i] + this.getSqlDelimiter());
        }
    }

    public void execute(String[] sqls) {
        String sql = null;
        String showSqlText = this.properties.getProperty("hibernate.show_sql");
        boolean showSql = "true".equalsIgnoreCase(showSqlText);
        try {
            this.createConnection();
            this.statement = this.connection.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                sql = sqls[i];
                String delimitedSql = sql + this.getSqlDelimiter();
                if (showSql) {
                    log.debug((Object)delimitedSql);
                }
                this.statement.executeUpdate(delimitedSql);
            }
        }
        catch (SQLException e) {
            throw new JbpmException("couldn't execute sql '" + sql + "'", (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                log.debug((Object)"couldn't close jdbc statement", (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                JDBCExceptionReporter.logWarnings((SQLWarning)this.connection.getWarnings());
                this.connection.clearWarnings();
                this.connectionProvider.closeConnection(this.connection);
                this.connectionProvider.close();
            }
            catch (SQLException e) {
                log.debug((Object)"couldn't close jdbc connection", (Throwable)e);
            }
        }
    }

    private void createConnection() throws SQLException {
        this.connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)this.properties);
        this.connection = this.connectionProvider.getConnection();
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    private synchronized String getSqlDelimiter() {
        if (sqlDelimiter == null) {
            sqlDelimiter = this.properties.getProperty("jbpm.sql.delimiter", ";");
        }
        return sqlDelimiter;
    }
}

