/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.hsqldb.Server;
import org.jboss.soa.esb.testutils.StdOut2Log4jFilter;

public class HsqldbUtil {
    private static Logger log = Logger.getLogger(HsqldbUtil.class);
    private static final String THREAD_NAME = "hypersonic-unittest";

    public static void startHsqldb(final String databaseFile, final String databaseName) throws Exception {
        Thread serverThread = new Thread(THREAD_NAME){

            public void run() {
                try {
                    Server server = new Server();
                    Logger targetLogger = Logger.getLogger((String)"org.hsqldb");
                    server.setLogWriter(new PrintWriter(new StdOut2Log4jFilter(server.getLogWriter(), log, targetLogger.getEffectiveLevel())));
                    server.setDatabasePath(0, databaseFile);
                    server.setDatabaseName(0, databaseName);
                    server.setNoSystemExit(true);
                    server.setSilent(true);
                    server.start();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        };
        serverThread.run();
    }

    public static void stopHsqldb(String url, String username, String password) throws Exception {
        Connection connection = DriverManager.getConnection(url, username, password);
        Statement statement = connection.createStatement();
        String shutdownCommand = "SHUTDOWN COMPACT";
        statement.executeQuery(shutdownCommand);
    }
}

