/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.wife.WifeException;
import net.sourceforge.wife.swift.model.IMessageVisitor;
import net.sourceforge.wife.swift.model.SwiftBlock;
import net.sourceforge.wife.swift.model.SwiftBlock1;
import net.sourceforge.wife.swift.model.SwiftBlock2;
import net.sourceforge.wife.swift.model.SwiftBlock3;
import net.sourceforge.wife.swift.model.SwiftBlock4;
import net.sourceforge.wife.swift.model.SwiftBlock5;
import net.sourceforge.wife.swift.model.SwiftBlockUser;
import net.sourceforge.wife.swift.model.SwiftMessage;
import net.sourceforge.wife.swift.model.Tag;
import net.sourceforge.wife.swift.model.UnparsedTextList;

public class FINWriterVisitor
implements IMessageVisitor {
    private static final transient Logger log = Logger.getLogger(FINWriterVisitor.class.getName());
    private static final String SWIFT_EOL = "\r\n";
    private Writer writer;
    private Boolean block4asText = Boolean.TRUE;

    public FINWriterVisitor(Writer writer) {
        this.writer = writer;
    }

    public void startMessage(SwiftMessage m) {
        SwiftBlock1 b1;
        this.block4asText = Boolean.TRUE;
        SwiftBlock1 swiftBlock1 = b1 = m != null ? m.getBlock1() : null;
        if (b1 != null) {
            String servId;
            String appId = b1.getApplicationId() != null ? b1.getApplicationId() : "";
            String string = servId = b1.getServiceId() != null ? b1.getServiceId() : "";
            this.block4asText = b1.getValue() == null || b1.getValue().equals("") ? Boolean.TRUE : (!appId.equals("F") || !servId.equals("01") ? Boolean.FALSE : Boolean.TRUE);
        } else {
            SwiftBlock2 b2;
            SwiftBlock2 swiftBlock2 = b2 = m != null ? m.getBlock2() : null;
            if (b2 != null) {
                String mt;
                String string = mt = b2.getMessageType() != null ? b2.getMessageType() : "";
                this.block4asText = mt.startsWith("0") ? Boolean.FALSE : Boolean.TRUE;
            } else {
                this.block4asText = Boolean.TRUE;
            }
        }
    }

    public void endMessage(SwiftMessage m) {
        if (m.getUnparsedTextsSize() > 0) {
            this.write(m.getUnparsedTexts());
        }
        this.block4asText = Boolean.TRUE;
    }

    public void startBlock1(SwiftBlock1 b) {
        this.write("{1:");
    }

    public void value(SwiftBlock1 b, String v) {
        if (v != null && !v.equals("")) {
            this.write(v);
        }
    }

    public void endBlock1(SwiftBlock1 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    public void startBlock2(SwiftBlock2 b) {
        this.write("{2:");
    }

    public void value(SwiftBlock2 b, String v) {
        if (v != null && !v.equals("")) {
            this.write(v);
        }
    }

    public void endBlock2(SwiftBlock2 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    public void startBlock3(SwiftBlock3 b) {
        this.write("{3:");
    }

    public void tag(SwiftBlock3 b, Tag t) {
        this.appendBlockTag(t);
    }

    public void endBlock3(SwiftBlock3 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    public void startBlock4(SwiftBlock4 b) {
        this.write("{4:" + (this.block4asText != false ? SWIFT_EOL : ""));
    }

    public void tag(SwiftBlock4 b, Tag t) {
        if (this.block4asText.booleanValue()) {
            this.appendTextTag(t);
        } else {
            this.appendBlockTag(t);
        }
    }

    public void endBlock4(SwiftBlock4 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write((this.block4asText != false ? "-" : "") + "}");
    }

    public void startBlock5(SwiftBlock5 b) {
        this.write("{5:");
    }

    public void tag(SwiftBlock5 b, Tag t) {
        this.appendBlockTag(t);
    }

    public void endBlock5(SwiftBlock5 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    public void startBlockUser(SwiftBlockUser b) {
        this.write("{" + b.getName() + ":");
    }

    public void tag(SwiftBlockUser b, Tag t) {
        this.appendBlockTag(t);
    }

    public void endBlockUser(SwiftBlockUser b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    public void tag(SwiftBlock b, Tag t) {
        if (b == null) {
            return;
        }
        if (b instanceof SwiftBlock3) {
            this.tag((SwiftBlock3)b, t);
        }
        if (b instanceof SwiftBlock4) {
            this.tag((SwiftBlock4)b, t);
        }
        if (b instanceof SwiftBlock5) {
            this.tag((SwiftBlock5)b, t);
        }
        if (b instanceof SwiftBlockUser) {
            this.tag((SwiftBlockUser)b, t);
        }
    }

    private final void appendBlockTag(Tag t) {
        String value;
        String name = t.getName() != null ? t.getName() : "";
        String string = value = t.getValue() != null ? t.getValue() : "";
        if (name.equals("") && value.equals("")) {
            return;
        }
        if (!name.equals("")) {
            this.write("{" + name + ":" + value);
        } else {
            this.write("{" + value);
        }
        if (t.getUnparsedTextsSize() > 0) {
            this.write(t.getUnparsedTexts());
        }
        this.write("}");
    }

    private final void appendTextTag(Tag t) {
        String value;
        String name = t.getName() != null ? t.getName() : "";
        String string = value = t.getValue() != null ? t.getValue() : "";
        if (!name.equals("")) {
            this.write(":" + name + ":" + value + SWIFT_EOL);
        }
        if (t.getUnparsedTextsSize() > 0) {
            this.write(t.getUnparsedTexts());
        }
    }

    protected String getTagValue(Tag t, int block) {
        String s = t.getValue();
        if (t.getName() == null && s.startsWith(block + ":") && s.length() > 2) {
            return s.substring(2);
        }
        return s;
    }

    private void write(UnparsedTextList texts) {
        if (texts.size() > 0) {
            for (int i = 0; i < texts.size(); ++i) {
                if (!texts.isMessage(new Integer(i)).booleanValue()) continue;
                this.write(texts.getText(new Integer(i)));
            }
        }
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Caught exception in FINWriterVisitor, method write", e);
            throw new WifeException(e);
        }
    }
}

